#######################################################
## Activité 2: Simulation de l'asservissement du MCC ##
#######################################################
import matplotlib.pyplot as plt

def Euler_Explicite(f,y0,t0,t1,dt):
    t = t0
    y = y0
    T = [t]
    Y = [y]
    i = 0
    while t < t1: 
        yp = f(y,t)
        y = [y[i] + yp[i]*dt for i in range(len(y))]
        i += 1
        t = t0 + i*dt # Important: Eviter les erreurs de t+=dt
        T.append(t)
        Y.append(y)
    return T,Y

def F(Y,t): # u variable globale
    R = 0.45
    L = 0.0046
    ke = 0.169
    kc = 0.17
    f = 0.01
    J = 0.01
    cr = 0
    i,w = Y
    di = (u-ke*w-R*i)/L
    dw = (kc*i-f*w-cr)/J
    Sol = [di,dw]
    return Sol

i0 = 0
w0 = 0
V0 = [i0,w0]
t0 = 0
t1 = 1
N = 1000
u = 10

dt = (t1-t0)/(N-1)
Lt,Y = Euler_Explicite(F,V0,t0,t1,dt)
Li = [Y[i][0] for i in range(len(Y))]
Lw = [Y[i][1] for i in range(len(Y))]

def f_Affiche(fig,Lx,Ly,Legende):
    plt.figure(fig)
    plt.plot(Lx,Ly,label=Legende)
    plt.legend()
    plt.show()
    plt.pause(0.0001)

f_Affiche(1,Lt,Li,'i')
f_Affiche(2,Lt,Lw,'w')

def MCC(V0,t0,t1,dt):
    Lt,Y = Euler_Explicite(F,V0,t0,t1,dt)
    Li = [Y[i][0] for i in range(len(Y))]
    Lw = [Y[i][1] for i in range(len(Y))]
    return Lt,Li,Lw

# Données de l'asservissement

Wc = # A COMPLETER     # Consigne (rd/s)
Kcapt = # A COMPLETER # Gain capteur (V/rd/s)
Ka = # A COMPLETER # Adaptateur (V/rd/s)
Uc = # A COMPLETER # Consigne au comparateur (V)

# Données numériques

dts = # A COMPLETER # Pas de temps résolution MCC (s)
ti = # A COMPLETER       # Temps initial simulation
tf = # A COMPLETER     # Temps final simulation
dt = dts   # Pas de temps de simulation

# Initialisation des données

i0 = # A COMPLETER
w0 = # A COMPLETER
u0 = # A COMPLETER
Li = [i0]
Lw = [w0]
Lu = [u0]
Lt = [ti]
Ltu = [ti]

# Boucle de simulation

k = 0 # Ne  pas mettre i car il s'agit du courant !!
t = ti
while t < tf:
    i = Li[-1]
    w = Lw[-1]
    V = [i,w]
    k += 1
    t = ti + k*dt # 
    r = # A COMPLETER
    eps = # A COMPLETER
    u = eps # On mettra un correcteur ici
    Ltu.append(t)
    Lu.append(u)
    ###########################################################################
    ## POUR L'ACTIVITE 3 AVEC LES CORRECTEURS ##
    # Créer la variable u(k-1) pour les correcteurs CPI et CAP
    # Créer une liste avec les valeurs de EPSILON ainsi que les variables  e(k) e(k-1) pour les correcteurs CPI et CAP
    ###########################################################################
    lt,li,lw = MCC(V,t,t+dt,dts)
    Li = Li + li
    Lw = Lw + lw
    Lt = Lt + lt

f_Affiche(3,Lt,Li,'i')
f_Affiche(4,Lt,Lw,'w')
